package editor;

import game.CustomImageDataII;
import game.IntRect;
import game.PlayingWithCosine;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ImageObserver;

public class HurtzonePaletteObject extends  MobileScreenPaletteObject {
	
	
	private boolean isVertical;
	
	private int duration;
	
	private int minimumWaitTime;
	
	private int fireChanceNumerator;
	private int fireChanceDenominator;
	
	private int warmupTime;
	private int damage;

	private double maxColor;
	private double minColor;
	
	
	
	private CustomImageDataII image;
	
	
	
	
	public HurtzonePaletteObject(IntRect theClickRect, boolean shouldBeVertical, int theDuration, int theMinWaitTime,
			int theFireChanceNumerator, int theFireChanceDenominator, int theWarmupTime, int theDamage, double theMinColor, 
			double theMaxColor, int theBorderWidth, int theDistanceToBorder, RoomEditorPanel thePanel) {
		
		
		distanceToBorder = theDistanceToBorder;
		borderWidth= theBorderWidth;
		
		editorPanel = thePanel;
		
		image = new CustomImageDataII("/images/hurtzone_smallIcon.GIF", Color.green, null);
		
		clickRect = theClickRect;
		isVertical = shouldBeVertical;
		duration = theDuration;
		minimumWaitTime = theMinWaitTime;
		fireChanceNumerator = theFireChanceNumerator;
		fireChanceDenominator = theFireChanceDenominator;
		warmupTime = theWarmupTime;
		damage = theDamage;
		minColor = theMinColor;
		maxColor = theMaxColor;
		
//		System.out.println("and the hurtzone clickrect has minX: " + clickRect.getMinX() + ", maxX: " + clickRect.getMaxX() + ", minY: " + clickRect.getMinY() + ", maxY: " + clickRect.getMaxY());
		
	}
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		IntRect newRect = new IntRect(objX - 30, objY-30, 60, 60);
		this.setMode(MobileScreenPaletteObject.SETTING_MIN);
		this.setConstructedObject(new HurtzoneScreenObject(this, newRect));
		return getConstructedObject();
	}
	@Override
	public void delete(ScreenObject so) {
		// TODO Auto-generated method stub
		
	}
	
	public static String multiplyIntByAThousandAndReturnAsString(int orig) {
		return Integer.toString(orig / 1000) + "." + guaranteeThreeDigitsMin(orig % 1000);
	}
	
	public static String guaranteeThreeDigitsMin(int orig) {
		if(orig / 10 == 0) {
			return "00" + Integer.toString(orig);
		} else if(orig / 100 == 0) {
			return "0" + Integer.toString(orig);
		} else {
			return Integer.toString(orig);
		}
	}
	
	@Override
	public void draw(Graphics g) {
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		
//		g.setColor(new Color(0, 150, 0));
//		
//		
//		String theString = multiplyIntByAThousandAndReturnAsString(minimumWaitTime);
//		
////		System.out.println("<><>DELME theString: " + theString);
//		
//		g.drawString(theString, clickRect.getMinX(), clickRect.getMinY() + 40);
		
		
		g.setColor(new Color(0, 150, 0));
		g.drawString("cd:" + HurtzonePaletteObject.multiplyIntByAThousandAndReturnAsString(this.getMinimumWaitTime()), clickRect.getMinX() + 3, clickRect.getMinY() + 40);
		g.setColor(new Color(200, 0, 0));
		g.drawString("d:" + this.getDamage(), clickRect.getMinX() + 36, clickRect.getMinY() + 20);
		g.setColor(new Color(50, 100, 150));
		g.drawString("du:"+ HurtzonePaletteObject.multiplyIntByAThousandAndReturnAsString(this.getDuration()), clickRect.getMinX() + 3, clickRect.getMinY() + 50);
		
		double minColor = this.getMinColor();
		double maxColor = this.getMaxColor();
		
		double avgColor = (minColor + maxColor) / 2;
		
		Color maybeIShouldntHaveCalledTheLastOneAvgColor = PlayingWithCosine.scalarToColor(avgColor);
		
		g.setColor(maybeIShouldntHaveCalledTheLastOneAvgColor);
		
		
		g.drawRect(clickRect.getMinX(), clickRect.getMinY(), clickRect.width(), clickRect.height());
		g.drawRect(clickRect.getMinX()+1, clickRect.getMinY()+1, clickRect.width()-2, clickRect.height()-2);
		
		
		
		
		g.setColor(origCol);
		
		

		this.getImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		
		
		
		
		
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
//		System.out.println("<><>DELME made it this far...borderWidth: " + borderWidth);
		
	}
	
	
	public CustomImageDataII getImage() {
		return image;
	}


	public boolean isVertical() {
		return isVertical;
	}


	public int getDuration() {
		return duration;
	}


	public int getMinimumWaitTime() {
		return minimumWaitTime;
	}


	public int getFireChanceNumerator() {
		return fireChanceNumerator;
	}


	public int getFireChanceDenominator() {
		return fireChanceDenominator;
	}


	public int getWarmupTime() {
		return warmupTime;
	}


	public int getDamage() {
		return damage;
	}


	public double getMaxColor() {
		return maxColor;
	}


	public double getMinColor() {
		return minColor;
	}


	public void setDuration(int duration) {
		this.duration = duration;
	}


	public void setMinimumWaitTime(int minimumWaitTime) {
		this.minimumWaitTime = minimumWaitTime;
	}


	public void setFireChanceNumerator(int fireChanceNumerator) {
		this.fireChanceNumerator = fireChanceNumerator;
	}


	public void setFireChanceDenominator(int fireChanceDenominator) {
		this.fireChanceDenominator = fireChanceDenominator;
	}


	public void setWarmupTime(int warmupTime) {
		this.warmupTime = warmupTime;
	}


	public void setDamage(int damage) {
		this.damage = damage;
	}


	public void setMaxColor(double maxColor) {
		this.maxColor = maxColor;
	}


	public void setMinColor(double minColor) {
		this.minColor = minColor;
	}

	
	
	
	
}
